<?php
/*
 * File: tplate.class.php
 * Created on 14.01.2006 by tp
 * Last Modified: 13.05.2007 by tp
 * 
 * contact: www.tp82.de
 * 
 * TPlate v2.1
 * http://projects.tp82.de/projects/tplate/
 *
 * You can use TPlate for free, but i would appreciate if you 
 * include the "powered by TPlate"-Logo in your site:
 * <a href="http://projects.tp82.de/projects/tplate/"><img src="http://tp82.de/microbanner/tplate_microbanner.gif" alt="powered by TPlate" title="powered by TPlate" style="border:none 0px;" /></a>
 *
 * This is just a minmial Template-System
 * Part of this Template-System is the template-class 'TPlate'
 * and in addition the data-container-class 'TPlateData'.
 * 
 * TPlate provides an add()-method to add any variable. the content of this variable
 * Is stored in the TPlateData-object.
 * The display()-method displays the specified template.
 * In principal, the template-files can contain real program-logic and intelligence,
 * because the display()-method only includes the template-file.
 * 
 * 
 * The template-files are just normal php-files.
 * The're beeing included in the TPlate-class' display()-method.
 * So they can not acces any variables outside of the current TPlate-object, 
 * except (super)global variables.
 * 
 */
 
 /**
  * the actual template-class
  */
 class TPlate {
    private static $general_tpldir = '';
    
 	private $tpldir;		// the directory in which the template-files are stored in
 	private $data;
 	private $template;

 	/**
 	 * 
 	 */ 	
 	public function __construct($dir='') {
 		$this->setTemplateDir($dir);	// set template-dir to current directory
 		$this->data = new TPlateData();
 	}
 	
 	/**
 	 * set the template-dir to $dir
 	 */
 	public function setTemplateDir($dir) {
 		$this->tpldir = $dir;
 	}

	 /**
 	 * display the template: $file
 	 * $file must be located in the $tpldir-directory!
 	 * once the display()-method is called, it deletes all added data!
 	 * if some data is needed later it must be added again. 
 	 */ 	
 	public function display($file) {
 		$data = &$this->data;
 		include("$this->tpldir/$file");
 		$this->removeAllData();
 	}
 	
 	
 	/**
 	 * Parses the template but does not display it, 
 	 * instead it's written in a string
 	 *
 	 * @param template-file to parse
 	 * @return String that contains the parsed template
 	 */
 	public function toString($file) {
 	   ob_start();
 	   $this->display($file);
 	   $string = ob_get_contents();
 	   //ob_clean();
 	   ob_end_clean();
 	   return $string;
 	}
 	
 	
 	/**
 	 * adds any kind of data to this TPlateobject
 	 * the data is stored in the TPlateData-container-object
 	 * because the data is passed as a copy, the template-file can not modify the original data
 	 */ 	
 	public function add($name, $value) {
 		$this->data->$name = $value;
 	}
 	
 	/**
 	* removes all data added to this TPlate-instance!
 	* In fact the TPlateData-container is unsetted and a new (empty) one is created
 	*/
 	protected function removeAllData() {
 		unset($this->data);		// delete all added data
 		$this->data = new TPlateData();
 	}
 	 

 	/**
 	 * This is used to set the default template dir, used by the newInstance-function
 	 */
 	public static function setDefaultTemplateDir($dir) {
 	   TPlate::$general_tpldir = $dir;
 	}
 	
 	
 	/**
 	 * This function allows to get new instances without specifiyng the template-dir anew each time  
 	 * 
 	 * @return new TPlate-instance using the default template dir
 	 */
 	public static function newInstance() {
 	   return new TPlate(TPlate::$general_tpldir);
 	}
 }
 
 /**
  * the data-container-class that is used by the TPlate-template-class
  */
 class TPlateData {
 	function __construct() {
 		// nothing to do here!
 	}
 }
?>
